
<%@include file="/jsp/init.jsp" %>


<c:set var="form_" value="${caretMap_['form_']}" />

<aui:a href="https://www.va.gov/vaforms/medical/pdf/vha-10-10CG.pdf" target="_blank" cssClass="icon-download-alt caret-menu-vet" style="margin-top: 7px;" label="download-1010cg" title="Download 10-10CG Form"></aui:a>

<c:if test="${!empty form_['CAREGIVER_IDS'] and form_['CAREGIVER_IDS'] lt 3}">
	<portlet:actionURL var="new1010">
		<portlet:param name="javax.portlet.action" value="doAction"/>
		<portlet:param name="action" value="loadApplication"/>
		<portlet:param name="TRACKER" value="${TRACKER}"/>
	</portlet:actionURL>
	<c:set var="newApp"><liferay-ui:message key="new-1010cg-application" /></c:set>
	<aui:nav cssClass="caret-nav">
       <aui:nav-item iconCssClass="icon-plus" label='${newApp}' href="${new1010}"  >
       </aui:nav-item>
    </aui:nav>
 </c:if>
 

<div id="tabSrc">
  <ul class="nav nav-tabs">
    <c:if test="${total_['myApplications'] gt 0}">
	    <li class="active tab-click"><a href="#tab-1">Veteran Dashboard</a></li>
    </c:if>
    <li class="tab-click" id="infomatnl"><a href="#tab-2">Informational</a></li>
    <c:if test="${not (total_['myApplications'] gt 0)}">
	    <li class="tab-click" id="preScreen"><a href="#tab-3">Pre-screening</a></li>
    </c:if>
  </ul>

  <div class="tab-content">
	  <c:if test="${total_['myApplications'] gt 0}">
	    <div id="tab-1" class="tab-pane">
	      	<div class="dashboard-top">
	      		<div class="online-split-pane">
	      			<fieldset>
				      	<legend><liferay-ui:message key="my-caregivers" /></legend>
				      	<c:set var="ndx0" value="role" />
				      	<c:set var="ndx1" value="caregiver-name" />
				      	<c:set var="emptyResultsMessage" value="no-caregivers-found" />
						<%@include file="/jsp/online/myVcgStatus.jsp" %>
					</fieldset>
	      		</div>
	      		<div class="online-split-pane">
	      			<fieldset>
			      		<legend ><liferay-ui:message key="my-notes" /></legend>
		      			<%@include file="/jsp/online/myMessages.jsp" %>
	      			</fieldset>
	      		</div>
	      	</div>
	      	<div class="clear-both"></div>
	      	<div id="dashboard-bottom">
			  <div class="online-cg-status-applications">
					 <fieldset>
					   	<legend ><liferay-ui:message key="my-apps" /></legend>
				  		<%@include file="/jsp/online/myApplications.jsp" %>
					</fieldset>
			  </div>
			</div>
	    </div>
    </c:if>
    
    <div id="tab-2" class="tab-pane">
		<%@include file="/jsp/online/information.jsp" %>
	</div>
    <c:if test="${not (total_['myApplications'] gt 0)}">
	    <div id="tab-3" class="tab-pane">
	    	<%@include file="/jsp/online/onlineQuestionaire.jsp" %>
	    </div>
    </c:if>
  </div>
</div>


<c:if test="${true eq form_['showConfirmation']}">
	<%@include file="/jsp/online/applicationSubmitted.jsp" %>
</c:if>


<div class="yui3-skin-sam">
	    <div id="modal33"></div>
	</div>
  

<aui:script use="aui-modal,aui-tabview">

  window.careTmainTab = new A.TabView({
      srcNode: '#tabSrc',
      type: 'pills'
    }
  );
  window.careTmainTab.render();
	  
	if (0 == "${total_['myApplications']}"){
	  	// window.careTmainTab.disableTab(3);
	  	// window.careTmainTab.selectChild(1);
	}
  A.all('.tab-click').attr('tabindex',0);
	
  
  var modals = new A.Modal({
      bodyContent: "Confirm: Do you want to delete your VA 10-10CG Application?",
      centered: true,
      destroyOnHide: false,
      headerContent: 'Delete Application',
      modal: true,
      render: '#modal33',
      resizable: {
        handles: 'b, r'
      },
      visible: false,
      width: 550
  });
  modals.addToolbar([ {
		label : 'Cancel',
		on : {
			click : function() {
				modals.hide();
			}
		}
	}, {
		label : 'Yes, Delete',
		on : {
			click : function() {
				window.location.href = A.one('#deleteUrl').val();
			}
		}
	} ]);
  
	
  window.deleteApp = function( id ) {
  		A.one('#deleteUrl').val(id);
		modals.render();
    	modals.show();	
  }
	
</aui:script>

<input type="hidden" id="deleteUrl" value="" />

<div id="chatVaMsg" >
	<a tabindex="0" class="tab-click btn-link search-vcg-action" onclick="window.open('https://www.ebenefits.va.gov/chat/chatstart.aspx?domain=1010cg','10-10 CG', 'width:500,height=600');" >
		Chat online &nbsp; with <i class="icon-comment">&nbsp; VA</i> representative </a>
</div>


